'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useTranslations } from 'next-intl';
import { useState, useEffect } from 'react';
import AnimatedText from '../../../components/AnimatedText';
import AnimatedElement from '../../../components/AnimatedElement';

export default function TeamPage() {
  const t = useTranslations('TeamPage');
  const [isDesktop, setIsDesktop] = useState(false);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  const teamMembers = [
    {
      name: t('member1.name'),
      title: t('member1.title'),
      description: [t('member1.desc1'), t('member1.desc2')],
      image: "/images/team/79c3016e5daaa87711da9e80ef0b9e00fc730056.png",
      linkedin: "https://www.linkedin.com/in/eldiyarmuratov/"
    },
    {
      name: t('member2.name'),
      title: t('member2.title'),
      description: [t('member2.desc1')],
      image: "/images/team/572fcd3e32821e7877c8810d2356bc9bebcd3006.jpg",
      linkedin: "https://www.linkedin.com/in/h-e-donald-gor%C3%A9e-kgc-founder-ceo-32229825?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=ios_app"
    },
    {
      name: t('member5.name'),
      title: t('member5.title'),
      description: [t('member5.desc1'), t('member5.desc2')],
      image: "/images/team/2af44e25fcc59bc4bd0f168a9877eb18d1a8e8cb.png",
      linkedin: "https://www.linkedin.com/in/seanjchan/"
    },
    {
      name: t('member3.name'),
      title: t('member3.title'),
      description: [t('member3.desc1'), t('member3.desc2')],
      image: "/images/team/2ad85d4319b25c8b46a27801ae4be27788abe683.jpg",
      linkedin: "https://www.linkedin.com/in/jbradleyhall/"
    },
    {
      name: t('member4.name'),
      title: t('member4.title'),
      description: [t('member4.desc1'), t('member4.desc2')],
      image: "/images/team/9b1398748f5bc7f6c760dc3c34d7120215071b46.png",
      linkedin: "https://www.linkedin.com/in/shakilmohammed/"
    },
    {
      name: t('member9.name'),
      title: t('member9.title'),
      description: [t('member9.desc1'), t('member9.desc2')],
      image: "/images/team/c5ea124feff0907bd2638092dee511c86be7013e.png",
      linkedin: "https://www.linkedin.com/in/sanjiv-garg-5a84b85/"
    },
    {
      name: t('member8.name'),
      title: t('member8.title'),
      description: [t('member8.desc1'), t('member8.desc2')],
      image: "/images/team/0f71f405d361f72f49d753c0733e9d688d856b4c.png",
      linkedin: "https://www.linkedin.com/in/andy-chung-yin-lo-75735a25/"
    },
    {
      name: t('member6.name'),
      title: t('member6.title'),
      description: [t('member6.desc1'), t('member6.desc2')],
      image: "/images/team/d011d17ea9b8c1a8093c0c3a989c1bbf7d45056f.png",
      linkedin: "https://www.linkedin.com/in/kent-tan-60100/"
    },
    {
      name: t('member7.name'),
      title: t('member7.title'),
      description: [t('member7.desc1'), t('member7.desc2')],
      image: "/images/team/392680b91b32f99303cc3b8cbd9739ca76794dc1.png",
      linkedin: "https://www.linkedin.com/in/zep-parmonangan-5805381b7/"
    }
  ];

  return (
    <div className={`flex w-full flex-col justify-center items-center bg-[#F5F1F0]`}>
      {isDesktop ? <Header /> : <MobileHeader />}

      {/* Title Section */}
      <div className={`flex h-[146px] py-[50px] px-8 justify-center items-center gap-2 bg-[#F5F1F0] w-full`}>
        <div className={`${isDesktop ? 'w-[1376px] mx-auto' : 'w-full'}`}>
          <AnimatedText
            as="h1"
            animation="slideInUp"
            delay={200}
            className="text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
          >
            {t('title')}
          </AnimatedText>
        </div>
      </div>

      {/* Team Members Section */}
      <div className={`flex w-full pb-[60px] flex-col items-start gap-10 ${isDesktop ? 'max-w-[1449px] mx-auto' : ''}`}>
        {teamMembers.map((member, index) => (
          <div key={index} className={`flex ${isDesktop ? 'px-8 items-start gap-6' : 'px-3 flex-col items-center gap-6'} w-full`}>
            {/* Photo */}
            <AnimatedElement 
              animation={isDesktop ? (index % 2 === 0 ? "slideInLeft" : "slideInRight") : "slideInUp"}
              delay={300 + index * 100}
              className={`${isDesktop ? 'w-[332px] h-[442px]' : 'w-full max-w-[320px] h-[427px]'} border-2 border-black/20 bg-gray-300 flex-shrink-0`}
            >
              <div
                className="w-full h-full"
                style={{
                  background: `url(${member.image}) lightgray 50% / cover no-repeat`,
                  filter: 'grayscale(100%)'
                }}
              ></div>
            </AnimatedElement>
            
            {/* Content */}
            <div className={`flex flex-col ${isDesktop ? 'justify-between items-start flex-1 self-stretch' : 'items-start gap-4 w-full'}`}>
              <div className="flex flex-col items-start gap-4 self-stretch">
                {/* Name and Title */}
                <div className="flex flex-col justify-end items-start gap-1 self-stretch">
                  <AnimatedText
                    as="h2"
                    animation={isDesktop ? (index % 2 === 0 ? "slideInRight" : "slideInLeft") : "slideInUp"}
                    delay={400 + index * 100}
                    className="text-[#1C1C1C] font-roboto text-[28px] font-normal leading-[130%]"
                  >
                    {member.name}
                  </AnimatedText>
                  <AnimatedText
                    as="p"
                    animation={isDesktop ? (index % 2 === 0 ? "slideInRight" : "slideInLeft") : "slideInUp"}
                    delay={600 + index * 100}
                    className="text-[#1C1C1C] font-roboto text-lg font-medium italic leading-[150%]"
                  >
                    {member.title}
                  </AnimatedText>
                </div>
                
                {/* Description */}
                <div className="flex flex-col items-start gap-2 self-stretch">
                  {member.description.map((paragraph, pIndex) => (
                    <AnimatedText
                      key={pIndex}
                      as="p"
                      animation={isDesktop ? (index % 2 === 0 ? "slideInRight" : "slideInLeft") : "slideInUp"}
                      delay={800 + index * 100 + pIndex * 200}
                      className="self-stretch text-[#1C1C1C] font-roboto text-lg font-light leading-[150%] whitespace-pre-line"
                    >
                      {paragraph}
                    </AnimatedText>
                  ))}
                </div>
              </div>
              
              {/* LinkedIn Button */}
              <AnimatedElement
                animation={isDesktop ? (index % 2 === 0 ? "slideInRight" : "slideInLeft") : "slideInUp"}
                delay={1000 + index * 100 + member.description.length * 200}
                className={`flex py-3 px-6 justify-center items-center gap-2 rounded-[2px] bg-[#A79D94] ${isDesktop ? '' : 'w-full'}`}
              >
                <a
                  href={member.linkedin}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-white font-roboto text-lg font-normal leading-[150%]"
                >
                  {t('linkedin_button')}
                </a>
              </AnimatedElement>
            </div>
          </div>
        ))}
      </div>

      <Footer />
    </div>
  );
} 